/*
  createNChildren.c
  Calls fork N times, printing the return values each time.
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

const int N = 3;

int main(int argc, char* argv[]) {
  if (argc > 2) {
    fprintf(stderr, "Use: createNChildren [count]\n");
    exit(1);
  }
  int count = N;
  if (argc == 2) count = atoi(argv[1]);  // Use strtol if checking for error input
  int startingPid = getpid();
  printf("pid: %d\n", startingPid);
  for (int i = 0; i < count; ++i) {
    if (fork() == 0) {
      printf("pid: %d; ppid: %d\n", getpid(), getppid());
      break;
    }
    else {
      wait(NULL);
    }
  }
}
